export default {
    ADMIN_CENTRAL: {
        FETCH_GROUP_USER_COUNT:'/adminCentral/fetch-group-user-count',
        RETRY_SYNCING: '/adminCentral/retry-syncing-groups'
    },
    AUTH: {
        CHECK_EMAIL: '/admin/check-email',
        CHECK_COMPANY: '/admin/check-company',
        LOG_IN: '/admin/login',
        REGISTER: '/admin/register',
        EMAIL_VERIFICATION: '/admin/verify-email',
        FORGOT_PASSWORD: '/admin/forgot-password',
        RESET_PASSWORD: '/admin/reset-password',
        LOG_OUT: '/admin/logout',
        RESEND_OTP: '/admin/resend-otp',
        TAC_LOGIN: '/admin/tac-login',
        VERIFY_TOKEN: '/admin/verify-token'
    },
    AUTO_SYNC: {
        SCHEDULE: '/auto-sync/enable-disable',
    },
    REPORTED_EMAIL: {
        LIST: '/reported-email/list',
        GET:'/reported-email/get',
        WHO_ELSE:'/reported-email/who-else',
        LINK:'/reported-email/urls',
        ATTACHMENTS:'/reported-email/attachments',
        EVENT: '/reported-email/events',
        DOWNLOAD_CSV: '/reported-email/download-csv',
        SIMILIAR_EMAILS: '/reported-email/similiar-email',
        IGNORED_LIST: '/reported-email/ignored-list'
    },
    BROADCAST: {
        LIST: '/broadcast/list',
        SEND_BROADCAST: '/broadcast/sendBroadcast'
    },
    DOMAIN:{
        LIST:'/domain/domain-list',
        CREATE:'/domain/domain-create',
        VERIFY:'/domain/domain-verify',
        DELETE:'/domain/domain-delete',
        DOMAIN_LIST:'/domain/list',
        GET: '/domain/domain-get',
        UPDATE_CRON:'/users/user-sync',
        UPDATE_DOMAIN: '/domain/update-domainGroups',
        LISTUSERSGROUPSANDSUBGROUPS: '/domain/list-groups-subgroups',
        SYNC_FROM_TA: '/adminCentral/sync-TA-verified-domains',
        UPDATE_WEBHOOK_EMAIL_FOR_DOMAIN: '/domain/update-rerpoting-webhook-email',
        CLEAR_MANUAL_CRED:'/domain/clear-domain-creds',
        AZURE_CONSENT_URL:'/integration/azure-consent-url',
    },
    GROUPS:{
        LIST: '/groups/list',
        GET: '/groups/get',
        ADDOREDIT: '/groups/addUsersToGroup',
        REMOVE_USER: '/groups/removeUserFromGroup',
        CHANGE_ACCESS: '/groups/grantAccess',
        DELETE: '/groups/delete-group'
    },
    CREDENTIAL:{
        OUTLOOK:'/domain/domain-credential-outlook',
        GSUITE:'domain/domain-credential-gsuite'
    },
    USERS:{
        LIST:'/users/user-list',
        SYNC:'/users/sync-user',
        DELETE:'/users/user-delete',
        DOWNLOAD:'/users/user-list-csv',
        CHANGE_STATUS:'/users/user-enable-disable',
        CHANGE_STATUS_MESSENGER:'/users/user-enable-disable-messenger',
        UPLOAD_USER: '/users/upload-csv-new',
        REPORT: '/users/user-report',
        BULK_OPERATION: '/users/bulk-operation'
    },
    ADVANCE_SEARCH: {
        LIST:'/advance-search/list',
        CREATE:'/advance-search/search',
        HISTORY:'/advance-search/emails',
        DELETE:'/advance-search/move-to-trash',
        BODY:'/advance-search/body',
        REMOVE:'/advance-search/remove-entry'
    },
    SETTINGS: {
        UPDATE_PROFILE: '/profile/update-profile',
        CHANGE_PASSWORD: '/admin/change-password',
        UPDATE_SOC: '/admin/update-soc-email',
        PROFILE_DETAILS: '/profile/details',
        API_KEY: '/settings/virus-total',
        UPDATE_BROADCAST_STATUS: '/settings/update-broadcast-status',
        LICENSE_KEY: '/settings/licence-key',
        TSAT_URL: '/settings/tsat-url',
        UPDATE_SMTP:'/settings/updateSmtp',
        SEND_TEST_MAIL:'/settings/test-mail',
        CHECK_PACKAGE:'/settings/check-lite',
        LOAD_TEMPLATES:'/template/list',
        GET_TEMPLATE:'/template/get',
        UPDATE_TEMPLATE: '/template/update-template',
        UPDATE_TIMEZONE: '/settings/update-time-zone',
        UPDATE_MESSENGER_STATUS: '/settings/update-messenger-status',
        UPDATE_REPORTING_METHOD: '/settings/update-reporting-method',
        UPDATE_SMTP_OAUTH_MANUAL:'/smtp/manual-creds',
        OAUTH_DIRECT_EMAIL:'/smtp/azure-consent',
        GET_SMTP_DETAILS: '/smtp/get-smtp',
        CLEAR_OAUTH:(id)=>`/smtp/delete-smtp/${id}`,
        DELETE_CUSTOM_SMTP :'/settings/delete-custom-smtp'
    },
    EMPLOYEE: {
        ADD: '/employee/add',
        LIST: '/employee/list',
        DELETE: '/employee/delete',
        UPDATE: '/employee/update',
        RESET_PASSWORD: '/employee/reset-password',
        PERMISSIONS: '/employee/permissions',
    },
    ROLES: {
        LIST: '/role/list',
        ADD: '/role/createRole',
        GET: '/role/get',
        UPDATE: '/role/updateRole',
        ASSIGN_ROLES: '/role/assignRole',
        DELETE: '/role/deleteRole'
    },
    POLICY: {
        LIST: '/policy/list',
        ADD: '/policy/add',
        EMPLOYEE_POLICY: '/policy/employee-policy'
    },
    ATTACHMENT:{
        SCAN: '/scan/scan-attachment',
        SYNC_RESULTS: '/scan/sync-attachments-result'
    },
    LINK:{
        SCAN: '/scan/scan-url'
    },
    WA_LINK:{
        SCAN: '/scan/scan-wa-url'
    },
    WHO_ELSE:{
        TRASH:'/mail-actions/move-to-trash-test',
        DELETE:'/mail-actions/move-to-delete-test',
        RECOVER:'/mail-actions/recover-test',
        SEARCH:'/report/who-else',
        MAIL_ACTIONS:'/mail-actions/bulk'
    },
    SIMILIAR_EMAIL:{
        SEARCH:'/report/similiar-email'
    },
    FILES: {
        DOWNLOAD: '/files/download'
    },
    AUDIT_LOGS:{
        GET: '/audit-logs/get'
    },
    PACKAGE:{
        SYNC:'/package/get-package',
        CHECK:'/package/get-features',
    },
    TWOFA:{
        MAIL: '/2fa/mail',
        QR: '/2fa/totp',
        VERIFY_QR:'/2fa/totp',
        DISABLED: '/2fa/disable',
    },
    HOME:{
        SUMMARY: '/overview/count',
        RECENT: '/overview/recent-whatsapp-reported',
        TOP_REPORTERS: '/overview/top-reporters',
        TOP_SENDERS: '/overview/top-senders',
        DAILY: '/overview/daily-reported',
        LICENCE: '/overview/check-licence',
        WHO_ELSE: '/overview/who-else',
        HIGHEST: '/overview/highest-reported-mail',
        VULNERABLEATTACHMENTANDURL: '/overview/vulnerable-attachment-url',
        SYNC_ORGANIZATION_DETAILS: '/adminCentral/sync-organisation-details',
    },
    WHATSAPP:{
        LIST: '/whatsapp/list',
        GET: '/whatsapp/get',
        ACTION: '/whatsapp/action',
        LINKS: '/whatsapp/urls',
        CONTACTS: '/whatsapp/contacts',
        BULK_OPERATION: '/whatsapp/bulk-operation',
        UPLOAD_CONTACTS: '/whatsapp/uploadContacts',
        OVERVIEW: '/whatsapp/overview'
    },
    USER_GROUPS:{
        GET: '/user-groups/get'
    },
    TA:{
        CHECK_CONNECTION: '/ta/check-connection',
        CONNECT: '/adminCentral/updateTaConnection'
    },
    SMART_BANNER:{
        ENABLE_DISABLE: '/smartBanners/enable-disable-banner',
        GET_STATUS: '/smartBanners/get-banner-status'
    }
}
